/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.FitDataSet;
import java.io.File;
import java.io.PrintStream;
import java.util.Locale;
import util.Config;
import util.Logger;

public class DDF255Writer {
    static Logger logger = Logger.getLogger();
    private FitDataSet mydata;
    private File myOutfile;
    private PrintStream pst;

    public DDF255Writer(File of, FitDataSet ps) {
        logger.entry(4, "DDF255Writer.DDF255Writer");
        this.myOutfile = of;
        this.mydata = ps;
        try {
            this.pst = new PrintStream(this.myOutfile);
        }
        catch (Exception e) {
            logger.log(1, "ERROR : " + e.toString());
        }
        logger.exit(4, "DDF255Writer.DDF255Writer");
    }

    private void writeHeader() {
        Config cfg = Config.getConfig();
        this.pst.print("#EEPROM ASCII FILE Rohde & Schwarz\r\n");
        this.pst.print("\r\n");
        this.pst.print("# --------------------\r\n");
        this.pst.print("# IDENTIFICATION_BLOCK\r\n");
        this.pst.print("# --------------------\r\n");
        this.pst.print("\r\n");
        this.pst.print("ID:                 IDENT_2\r\n");
        this.pst.print("ALIGNMENT:          32\r\n");
        this.pst.print("EEPROMSIZE:         0\r\n");
        this.pst.print("PARTNUMBER:         ");
        this.pst.print(String.valueOf(cfg.getParam("Partnumber")) + "\r\n");
        this.pst.print("HWCODE:             1\r\n");
        this.pst.print("PRODUCTINDEX:       01.00\r\n");
        this.pst.print("SN:                 ");
        this.pst.print(String.valueOf(cfg.getParam("Serialnumber")) + "\r\n");
        this.pst.print("PRODUCTDATE:        ");
        this.pst.print(String.valueOf(cfg.getParam("Productdate")) + "\r\n");
        this.pst.print("READCODE:           1\r\n");
        this.pst.print("TESTINSTRUCTION:    03.00\r\n");
        this.pst.print("NAME:               ");
        this.pst.print(String.valueOf(cfg.getParam("Antennaname")) + "\r\n");
        this.pst.print("\r\n");
        this.pst.print("\r\n");
        this.pst.print("# ---------------------\r\n");
        this.pst.print("# USERBLK_ANTENNA_IDENT\r\n");
        this.pst.print("# ---------------------\r\n");
        this.pst.print("\r\n");
        this.pst.print("ID:                 USER_18300\r\n");
        this.pst.print("FORMAT:             UINT16\r\n");
        this.pst.print(String.valueOf(cfg.getParam("Antennacode")) + "\r\n");
        String fulldate = cfg.getParam("Productdate");
        String[] parts = fulldate.split("[-]");
        String year = parts[0];
        String month = parts[1];
        String day = parts[2];
        this.pst.print(String.valueOf(year) + "\r\n");
        this.pst.print(String.valueOf(month) + "\r\n");
        this.pst.print(String.valueOf(day) + "\r\n");
        this.pst.print("FORMAT:             DOUBLE\r\n");
        this.pst.print(String.valueOf(cfg.getParam("BeginFrequency")) + "\r\n");
        this.pst.print(String.valueOf(cfg.getParam("EndFrequency")) + "\r\n");
        this.pst.print("FORMAT:             UINT16\r\n");
        this.pst.print("1\r\n");
        this.pst.print("0\r\n");
        this.pst.print("FORMAT:             UINT32\r\n");
        this.pst.print("0\r\n");
        this.pst.print("0\r\n");
        this.pst.print("0\r\n");
        this.pst.print("0\r\n");
        this.pst.print("FORMAT:             STRING\r\n");
        this.pst.print("\"" + cfg.getParam("Antennaname") + "\"\r\n");
        this.pst.print("FORMAT:             STRING\r\n");
        this.pst.print("\"Rohde&Schwarz\"\r\n");
        this.pst.print("\r\n");
        this.pst.print("\r\n");
    }

    private void writeEndBlock() {
        this.pst.print("# ---------\r\n");
        this.pst.print("# END BLOCK\r\n");
        this.pst.print("# ---------\r\n");
        this.pst.print("ID:                 END\r\n");
    }

    public void write() {
        Locale loc = Locale.US;
        this.writeHeader();
        for (double f : this.mydata.getFrequencies()) {
            String sf = String.valueOf(f / 1000000.0);
            this.pst.print("# -----------------------\r\n");
            this.pst.print("# USERBLK_AZIMUT\r\n");
            this.pst.print("# -----------------------\r\n");
            this.pst.print("# " + sf + " MHz\r\n");
            this.pst.print("# -----------------------\r\n");
            this.pst.print("\r\n");
            this.pst.print("ID:                 USER_18340\r\n");
            this.pst.print("FORMAT:             DOUBLE\r\n");
            this.pst.printf(loc, "%.2f\r\n", f);
            this.pst.print("FORMAT:             UINT8\r\n");
            this.pst.print("0\r\n");
            this.pst.print("0\r\n");
            this.pst.print("FORMAT:             COUNT16\r\n");
            int nodes = this.mydata.getFitData(f).getNodesIn();
            this.pst.print(String.valueOf(String.valueOf(nodes)) + "\r\n");
            this.pst.print("FORMAT:             FLOAT\r\n");
            int i = 0;
            while (i < nodes) {
                double val = this.mydata.getFitData(f).getXin(i);
                double corrval = this.mydata.getFitData(f).getCorrectedVal(val);
                double rounded = Math.rint(corrval * 100.0) / 100.0;
                double target = 360.0 / (double)nodes * (double)i;
                this.pst.printf(loc, "%-6.2f  // %6.2f\r\n", rounded, target);
                ++i;
            }
            this.pst.print("\r\n");
            this.pst.print("\r\n");
        }
        this.writeEndBlock();
    }
}

